/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.mss;

import ibm.nways.jdm.GraphicActionNavigate;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.Log;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.RemoteStatus;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.StatusProxy;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import java.awt.Point;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class BoxGraphic {
    private GenModel mssModel;
    private GenModel base8210ResetModel;
    private GenModel pci8210Model;
    private GenModel pcmcia8210Model;
    private GenModel systemModel;
    private JdmBrowser mssJdmBrowser;
    private Vector modelList;
    private Vector remoteStatusList;
    private Vector proxyStatusList;
    private Vector pcmcia_Info = new Vector();
    private boolean loggingOK;
    private static final String PropertiesFile = "properties/Mss.txt";
    private static final String layoutKey = "box.layout.scheme";
    private static final String fractKey = "box.layout.fractions";
    static final int startingX = 20;

    protected BoxGraphic(JdmBrowser jdmBrowser) {
        this.modelList = new Vector();
        this.remoteStatusList = new Vector();
        this.proxyStatusList = new Vector();
        this.mssJdmBrowser = jdmBrowser;
        this.loggingOK = this.checkLogging(this.mssJdmBrowser);
    }

    protected GraphicPanel getGraphicPanel() {
        GraphicContainer graphicContainer;
        block35: {
            String string;
            ModelInfo modelInfo;
            GraphicImage graphicImage;
            Object object;
            StatusProxy statusProxy;
            block34: {
                block33: {
                    Vector vector;
                    block32: {
                        Object object2;
                        Properties properties;
                        Serializable serializable;
                        graphicContainer = new GraphicContainer();
                        vector = new Vector();
                        statusProxy = null;
                        try {
                            serializable = new URL(this.mssJdmBrowser.getDocumentBase(), PropertiesFile);
                            if (this.loggingOK) {
                                System.out.println("DocumentBase = " + this.mssJdmBrowser.getDocumentBase());
                            }
                            properties = new Properties();
                            properties.load(((URL)serializable).openStream());
                        }
                        catch (Exception exception) {
                            if (this.loggingOK) {
                                System.out.println("Error getting Mss Properties: " + exception.getMessage());
                            }
                            properties = null;
                            exception.printStackTrace();
                        }
                        this.loggingOK = this.checkLogging(this.mssJdmBrowser);
                        JdmLayout jdmLayout = (JdmLayout)this.mssJdmBrowser.getLayout();
                        if (properties != null) {
                            serializable = new Integer((String)((Hashtable)properties).get(layoutKey));
                            if (this.loggingOK) {
                                System.out.println("The layout scheme property = " + serializable);
                            }
                            int n = (Integer)serializable;
                            jdmLayout.setScheme(n);
                            object2 = (String)((Hashtable)properties).get(fractKey);
                            object = new StringTokenizer((String)object2);
                            float[] fArray = new float[((StringTokenizer)object).countTokens()];
                            boolean bl = true;
                            int n2 = 0;
                            while (n2 < fArray.length && ((StringTokenizer)object).hasMoreTokens()) {
                                String string2 = ((StringTokenizer)object).nextToken();
                                try {
                                    fArray[n2] = Float.valueOf(string2).floatValue();
                                }
                                catch (NumberFormatException numberFormatException) {
                                    if (this.loggingOK) {
                                        System.out.println("Bad layout.fractions parm(" + numberFormatException.getMessage() + ")");
                                    }
                                    bl = false;
                                }
                                ++n2;
                            }
                            if (bl) {
                                jdmLayout.setFracts(fArray);
                            }
                        }
                        this.getBoxInfo();
                        ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.mss.Resources");
                        serializable = null;
                        graphicImage = new GraphicImage(this.mssJdmBrowser.imageFrom(this, "Mss8210.gif"), new Point(20, 0), 3, new GraphicActionNavigate(this.mssJdmBrowser, new NavigationDestination("ibm.nways.mib2.SystemInfoPanel", this.systemModel), (NavigationContext)((Object)serializable)), null);
                        graphicContainer.add(graphicImage);
                        object2 = new GraphicHelp(this.mssJdmBrowser, new Point(0, 0), new HelpRef(this));
                        graphicContainer.add((GraphicComponent)object2);
                        graphicImage = new GraphicImage(this.mssJdmBrowser.imageFrom(this, "Rs232.gif"), new Point(82, 95), 0, new GraphicActionNavigate(this.mssJdmBrowser, null, null), null);
                        String string3 = resourceBundle.getString("Serial Port");
                        GraphicFlyOver graphicFlyOver = new GraphicFlyOver(string3);
                        graphicImage.setFlyOver(graphicFlyOver);
                        graphicContainer.add(graphicImage);
                        graphicImage = new GraphicImage(this.mssJdmBrowser.imageFrom(this, "single1.gif"), new Point(228, 104), 0, new GraphicActionNavigate(this.mssJdmBrowser, new NavigationDestination("ibm.nways.mss.Reset8210Panel", this.base8210ResetModel), null), null);
                        string3 = resourceBundle.getString("Reset");
                        graphicFlyOver = new GraphicFlyOver(string3);
                        graphicImage.setFlyOver(graphicFlyOver);
                        graphicContainer.add(graphicImage);
                        try {
                            vector = this.pci8210Model.getRestOfInfo("Config", "default", null, null);
                        }
                        catch (Exception exception) {
                            if (!this.loggingOK) break block32;
                            System.out.println("Couldn't get PCI Model");
                        }
                    }
                    try {
                        modelInfo = (ModelInfo)vector.elementAt(1);
                        string = modelInfo.get("Config.Mss8210PCIAdapType").toString();
                        if (this.loggingOK) {
                            System.out.println("PCI slot #2 type=" + string);
                        }
                        object = this.pci8210Model.getStatusRefForRow(modelInfo);
                        this.remoteStatusList.addElement(object);
                        statusProxy = new StatusProxy((RemoteStatus)object);
                        this.proxyStatusList.addElement(statusProxy);
                        graphicImage = this.getPciImage(string, 2, graphicContainer, statusProxy, modelInfo);
                        graphicContainer.add(graphicImage);
                    }
                    catch (Exception exception) {
                        if (this.loggingOK) {
                            System.out.println("No PCI Port #2");
                        }
                        object = new Integer(4);
                        graphicImage = this.getPciImage(((Integer)object).toString(), 2, null, null, null);
                        graphicContainer.add(graphicImage);
                    }
                    try {
                        modelInfo = (ModelInfo)vector.elementAt(0);
                        string = modelInfo.get("Config.Mss8210PCIAdapType").toString();
                        if (this.loggingOK) {
                            System.out.println("PCI slot #1 type=" + string);
                        }
                        object = this.pci8210Model.getStatusRefForRow(modelInfo);
                        this.remoteStatusList.addElement(object);
                        statusProxy = new StatusProxy((RemoteStatus)object);
                        this.proxyStatusList.addElement(statusProxy);
                        graphicImage = this.getPciImage(string, 1, graphicContainer, statusProxy, modelInfo);
                        graphicContainer.add(graphicImage);
                    }
                    catch (Exception exception) {
                        if (this.loggingOK) {
                            System.out.println("No PCI Port #1");
                        }
                        object = new Integer(4);
                        graphicImage = this.getPciImage(((Integer)object).toString(), 1, null, null, null);
                        graphicContainer.add(graphicImage);
                    }
                    try {
                        this.pcmcia_Info = this.pcmcia8210Model.getRestOfInfo("Config", "default", null, null);
                    }
                    catch (Exception exception) {
                        if (!this.loggingOK) break block33;
                        System.out.println("Couldn't get PCMCIA Model");
                    }
                }
                try {
                    modelInfo = (ModelInfo)this.pcmcia_Info.elementAt(0);
                    string = modelInfo.get("Config.Mss8210PCAdapType").toString();
                    if (this.loggingOK) {
                        System.out.println("Box pcmcia slot #1 type=" + string);
                    }
                    object = this.pcmcia8210Model.getStatusRefForRow(modelInfo);
                    this.remoteStatusList.addElement(object);
                    statusProxy = new StatusProxy((RemoteStatus)object);
                    this.proxyStatusList.addElement(statusProxy);
                    graphicImage = this.getPcmciaImage(string, 1, modelInfo);
                    if (graphicImage != null) {
                        graphicImage.setStatus(statusProxy);
                        graphicContainer.add(graphicImage);
                    }
                }
                catch (Exception exception) {
                    if (!this.loggingOK) break block34;
                    System.out.println("No 8210 pcmcia Adapter in Slot #1");
                }
            }
            try {
                modelInfo = (ModelInfo)this.pcmcia_Info.elementAt(1);
                string = modelInfo.get("Config.Mss8210PCAdapType").toString();
                if (this.loggingOK) {
                    System.out.println("Box pcmcia slot #2 type=" + string);
                }
                object = this.pcmcia8210Model.getStatusRefForRow(modelInfo);
                this.remoteStatusList.addElement(object);
                statusProxy = new StatusProxy((RemoteStatus)object);
                this.proxyStatusList.addElement(statusProxy);
                graphicImage = this.getPcmciaImage(string, 2, modelInfo);
                if (graphicImage != null) {
                    if (this.loggingOK) {
                        System.out.println("Setting Status PCMCIA 8210 #2");
                    }
                    graphicImage.setStatus(statusProxy);
                    graphicContainer.add(graphicImage);
                }
            }
            catch (Exception exception) {
                if (!this.loggingOK) break block35;
                System.out.println("No 8210 pcmcia Adapter in Slot #2");
            }
        }
        GraphicPanel graphicPanel = new GraphicPanel(this.mssJdmBrowser, graphicContainer);
        return graphicPanel;
    }

    private void getBoxInfo() {
        block19: {
            block18: {
                block17: {
                    block16: {
                        this.loggingOK = this.checkLogging(this.mssJdmBrowser);
                        if (this.pci8210Model == null) {
                            try {
                                this.pci8210Model = (GenModel)this.mssModel.getComponent("Pci8210");
                                if (this.loggingOK) {
                                    System.out.println("Got Pci8210");
                                }
                            }
                            catch (Exception exception) {
                                if (!this.loggingOK) break block16;
                                System.out.println("Exception getting Graphic Base 8210");
                            }
                        }
                    }
                    if (this.pcmcia8210Model == null) {
                        try {
                            this.pcmcia8210Model = (GenModel)this.mssModel.getComponent("Pcmcia8210");
                            if (this.loggingOK) {
                                System.out.println("Got pcmcia 8210");
                            }
                        }
                        catch (Exception exception) {
                            if (!this.loggingOK) break block17;
                            System.out.println("Exception getting Graphic Base 8210");
                        }
                    }
                }
                if (this.base8210ResetModel == null) {
                    try {
                        this.base8210ResetModel = (GenModel)this.mssModel.getComponent("Base8210Reset");
                        if (this.loggingOK) {
                            System.out.println("Got base8210Reset");
                        }
                    }
                    catch (Exception exception) {
                        if (!this.loggingOK) break block18;
                        System.out.println("Exception getting Graphic Base 8210 reset");
                    }
                }
            }
            if (this.systemModel == null) {
                try {
                    this.systemModel = (GenModel)this.mssModel.getComponent("System");
                    if (this.loggingOK) {
                        System.out.println("Got system model");
                        return;
                    }
                }
                catch (Exception exception) {
                    if (!this.loggingOK) break block19;
                    System.out.println("Exception getting Graphic System Model");
                    return;
                }
            }
        }
    }

    protected void setMssModel(GenModel genModel) {
        this.mssModel = genModel;
    }

    private GraphicImage getPciImage(String string, int n, GraphicContainer graphicContainer, Status status, ModelInfo modelInfo) {
        GraphicImage graphicImage;
        this.loggingOK = this.checkLogging(this.mssJdmBrowser);
        NavigationDestination navigationDestination = new NavigationDestination("ibm.nways.mss.eui.PciAdapterPanel", this.pci8210Model);
        NavigationContext navigationContext = new NavigationContext();
        NavInitialRow.setInitialRow(navigationContext, modelInfo);
        GraphicActionNavigate graphicActionNavigate = new GraphicActionNavigate(this.mssJdmBrowser, navigationDestination, navigationContext);
        Integer n2 = new Integer(string);
        int n3 = n2;
        switch (n3) {
            case 1: {
                graphicImage = new UnknownPCI(this.mssJdmBrowser);
                ((UnknownPCI)graphicImage).setSlot(n);
                graphicImage.setAction(graphicActionNavigate);
                graphicImage.setStatus(status);
                break;
            }
            case 2: {
                graphicImage = new AtmPCI(this.mssJdmBrowser);
                ((AtmPCI)graphicImage).setSlot(n);
                graphicImage.setAction(graphicActionNavigate);
                graphicImage.setStatus(status);
                break;
            }
            case 3: {
                if (n == 1) {
                    graphicImage = new GraphicImage(this.mssJdmBrowser.imageFrom(this, "fddi10sm.gif"), new Point(276, 46), 1, new GraphicActionNavigate(this.mssJdmBrowser, null, null), null);
                    graphicContainer.add(graphicImage);
                } else {
                    graphicImage = new GraphicImage(this.mssJdmBrowser.imageFrom(this, "fddi10sm.gif"), new Point(276, 12), 1, new GraphicActionNavigate(this.mssJdmBrowser, null, null), null);
                    graphicContainer.add(graphicImage);
                }
                graphicImage = new FddiPCI(this.mssJdmBrowser, "A");
                ((FddiPCI)graphicImage).setSlot(n);
                graphicImage.setAction(graphicActionNavigate);
                graphicImage.setStatus(status);
                graphicContainer.add(graphicImage);
                graphicImage = new FddiBypass(this.mssJdmBrowser);
                ((FddiBypass)graphicImage).setSlot(n);
                graphicContainer.add(graphicImage);
                graphicImage = new FddiPCI(this.mssJdmBrowser, "B");
                ((FddiPCI)graphicImage).setSlot(n);
                graphicImage.setStatus(status);
                graphicImage.setAction(graphicActionNavigate);
                break;
            }
            case 4: {
                graphicImage = new NotPresentPCI(this.mssJdmBrowser);
                ((NotPresentPCI)graphicImage).setSlot(n);
                break;
            }
            default: {
                if (this.loggingOK) {
                    System.out.println("Unexpected PCI type =" + string);
                }
                graphicImage = new NotPresentPCI(this.mssJdmBrowser);
                ((NotPresentPCI)graphicImage).setSlot(n);
            }
        }
        return graphicImage;
    }

    private GraphicImage getPcmciaImage(String string, int n, ModelInfo modelInfo) {
        GraphicImage graphicImage;
        this.loggingOK = this.checkLogging(this.mssJdmBrowser);
        Integer n2 = new Integer(string);
        int n3 = n2;
        NavigationDestination navigationDestination = new NavigationDestination("ibm.nways.mss.eui.PcmciaAdapter8210Panel", this.pcmcia8210Model);
        NavigationContext navigationContext = new NavigationContext();
        NavInitialRow.setInitialRow(navigationContext, modelInfo);
        GraphicActionNavigate graphicActionNavigate = new GraphicActionNavigate(this.mssJdmBrowser, navigationDestination, navigationContext);
        switch (n3) {
            case 2: {
                graphicImage = new Harddrive8210PCA(this.mssJdmBrowser);
                ((Harddrive8210PCA)graphicImage).setSlot(n);
                graphicImage.setAction(graphicActionNavigate);
                break;
            }
            case 3: {
                graphicImage = new Modem8210PCA(this.mssJdmBrowser);
                ((Modem8210PCA)graphicImage).setSlot(n);
                graphicImage.setAction(graphicActionNavigate);
                break;
            }
            case 5: {
                graphicImage = new Flash8210PCA(this.mssJdmBrowser);
                ((Flash8210PCA)graphicImage).setSlot(n);
                graphicImage.setAction(graphicActionNavigate);
                break;
            }
            case 1: {
                graphicImage = new Unknown8210PCA(this.mssJdmBrowser);
                ((Unknown8210PCA)graphicImage).setSlot(n);
                graphicImage.setAction(graphicActionNavigate);
                break;
            }
            case 4: {
                graphicImage = new NotPresent8210PCA(this.mssJdmBrowser);
                ((NotPresent8210PCA)graphicImage).setSlot(n);
                graphicImage.setAction(graphicActionNavigate);
                break;
            }
            default: {
                graphicImage = null;
                if (!this.loggingOK) break;
                System.out.println("Unexpected Pcmcia type =" + string);
            }
        }
        return graphicImage;
    }

    public boolean checkLogging(JdmBrowser jdmBrowser) {
        if (jdmBrowser.getIsApplication()) {
            return Log.getLog().getLoggingState();
        }
        return false;
    }

    class FddiBypass
    extends GraphicImage {
        private JdmBrowser browser;
        private GraphicFlyOver flyOver;
        private int slot;

        public FddiBypass(JdmBrowser jdmBrowser) {
            BoxGraphic.this = BoxGraphic.this;
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.mss.Resources");
            this.setZOrder(0);
            this.setImage(jdmBrowser.imageFrom(this, "fddi.gif"));
            String string = resourceBundle.getString("bypass");
            this.flyOver = new GraphicFlyOver(string);
            this.setFlyOver(this.flyOver);
        }

        protected void setSlot(int n) {
            this.slot = n;
            if (this.slot == 1) {
                this.setLocation(new Point(406, 53));
                return;
            }
            this.setLocation(new Point(406, 18));
        }
    }

    class FddiPCI
    extends GraphicImage {
        private JdmBrowser browser;
        private GraphicFlyOver flyOver;
        private GraphicActionNavigate graphicAction;
        private int slot;
        private String portType;

        public FddiPCI(JdmBrowser jdmBrowser, String string) {
            BoxGraphic.this = BoxGraphic.this;
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.mss.Resources");
            this.setZOrder(0);
            this.setImage(jdmBrowser.imageFrom(this, "sc.gif"));
            this.portType = string;
            String string2 = this.portType.equals("A") ? resourceBundle.getString("fddiaport") : resourceBundle.getString("fddibport");
            this.flyOver = new GraphicFlyOver(string2);
            this.setFlyOver(this.flyOver);
        }

        public void setSlot(int n) {
            this.slot = n;
            if (this.slot == 1) {
                if (this.portType.equals("A")) {
                    this.setLocation(new Point(361, 53));
                    return;
                }
                this.setLocation(new Point(309, 53));
                return;
            }
            if (this.portType.equals("A")) {
                this.setLocation(new Point(361, 18));
                return;
            }
            this.setLocation(new Point(309, 18));
        }
    }

    class AtmPCI
    extends GraphicImage {
        private JdmBrowser browser;
        private GraphicFlyOver flyOver;
        private GraphicActionNavigate graphicAction;
        private int slot;

        public AtmPCI(JdmBrowser jdmBrowser) {
            BoxGraphic.this = BoxGraphic.this;
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.mss.Resources");
            this.setZOrder(0);
            this.setImage(jdmBrowser.imageFrom(this, "sc.gif"));
            String string = resourceBundle.getString("ATM PCI Adapter");
            this.flyOver = new GraphicFlyOver(string);
            this.setFlyOver(this.flyOver);
        }

        protected void setSlot(int n) {
            this.slot = n;
            if (this.slot == 1) {
                this.setLocation(new Point(335, 51));
                return;
            }
            this.setLocation(new Point(335, 16));
        }
    }

    class UnknownPCI
    extends GraphicImage {
        private JdmBrowser browser;
        private GraphicFlyOver flyOver;
        private GraphicActionNavigate graphicAction;
        private int slot;

        public UnknownPCI(JdmBrowser jdmBrowser) {
            BoxGraphic.this = BoxGraphic.this;
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.mss.Resources");
            this.setZOrder(0);
            this.setImage(jdmBrowser.imageFrom(this, "sc.gif"));
            String string = resourceBundle.getString("UNKNOWN");
            this.flyOver = new GraphicFlyOver(string);
            this.setFlyOver(this.flyOver);
        }

        protected void setSlot(int n) {
            this.slot = n;
            if (this.slot == 1) {
                this.setLocation(new Point(335, 51));
                return;
            }
            this.setLocation(new Point(335, 16));
        }
    }

    class NotPresentPCI
    extends GraphicImage {
        private int slot;

        public NotPresentPCI(JdmBrowser jdmBrowser) {
            BoxGraphic.this = BoxGraphic.this;
            this.setZOrder(0);
            this.setImage(jdmBrowser.imageFrom(this, "emptyUFC.gif"));
        }

        protected void setSlot(int n) {
            this.slot = n;
            if (this.slot == 1) {
                this.setLocation(new Point(276, 46));
                return;
            }
            this.setLocation(new Point(276, 12));
        }
    }

    class Harddrive8210PCA
    extends GraphicImage {
        private JdmBrowser browser;
        private GraphicFlyOver flyOver;
        private GraphicActionNavigate graphicAction;
        private int slot;

        public Harddrive8210PCA(JdmBrowser jdmBrowser) {
            BoxGraphic.this = BoxGraphic.this;
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.mss.Resources");
            this.setZOrder(0);
            this.setImage(jdmBrowser.imageFrom(this, "hdrive.gif"));
            String string = resourceBundle.getString("Harddrive");
            this.flyOver = new GraphicFlyOver(string);
            this.setFlyOver(this.flyOver);
        }

        protected void setSlot(int n) {
            this.slot = n;
            if (this.slot == 1) {
                this.setLocation(new Point(410, 97));
                return;
            }
            this.setLocation(new Point(522, 97));
        }
    }

    class Modem8210PCA
    extends GraphicImage {
        private JdmBrowser browser;
        private GraphicFlyOver flyOver;
        private GraphicActionNavigate graphicAction;
        private int slot;

        public Modem8210PCA(JdmBrowser jdmBrowser) {
            BoxGraphic.this = BoxGraphic.this;
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.mss.Resources");
            this.setZOrder(0);
            this.setImage(jdmBrowser.imageFrom(this, "modem.gif"));
            String string = resourceBundle.getString("Modem");
            this.flyOver = new GraphicFlyOver(string);
            this.setFlyOver(this.flyOver);
        }

        protected void setSlot(int n) {
            this.slot = n;
            if (this.slot == 1) {
                this.setLocation(new Point(410, 97));
                return;
            }
            this.setLocation(new Point(522, 97));
        }
    }

    class Flash8210PCA
    extends GraphicImage {
        private JdmBrowser browser;
        private GraphicFlyOver flyOver;
        private GraphicActionNavigate graphicAction;
        private int slot;

        public Flash8210PCA(JdmBrowser jdmBrowser) {
            BoxGraphic.this = BoxGraphic.this;
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.mss.Resources");
            this.setZOrder(0);
            this.setImage(jdmBrowser.imageFrom(this, "flash.gif"));
            String string = resourceBundle.getString("Flash");
            this.flyOver = new GraphicFlyOver(string);
            this.setFlyOver(this.flyOver);
        }

        protected void setSlot(int n) {
            this.slot = n;
            if (this.slot == 1) {
                this.setLocation(new Point(410, 97));
                return;
            }
            this.setLocation(new Point(522, 97));
        }
    }

    class Unknown8210PCA
    extends GraphicImage {
        private JdmBrowser browser;
        private GraphicFlyOver flyOver;
        private int slot;

        public Unknown8210PCA(JdmBrowser jdmBrowser) {
            BoxGraphic.this = BoxGraphic.this;
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.mss.Resources");
            this.setZOrder(0);
            this.setImage(jdmBrowser.imageFrom(this, "Pcmcia8210.gif"));
            String string = resourceBundle.getString("UNKNOWN");
            this.flyOver = new GraphicFlyOver(string);
            this.setFlyOver(this.flyOver);
        }

        protected void setSlot(int n) {
            this.slot = n;
            if (this.slot == 1) {
                this.setLocation(new Point(410, 97));
                return;
            }
            this.setLocation(new Point(522, 97));
        }
    }

    class NotPresent8210PCA
    extends GraphicImage {
        private JdmBrowser browser;
        private int slot;
        private GraphicFlyOver flyOver;

        public NotPresent8210PCA(JdmBrowser jdmBrowser) {
            BoxGraphic.this = BoxGraphic.this;
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.mss.Resources");
            this.setZOrder(0);
            this.setImage(jdmBrowser.imageFrom(this, "epcmcia.gif"));
            String string = resourceBundle.getString("Empty");
            this.flyOver = new GraphicFlyOver(string);
            this.setFlyOver(this.flyOver);
        }

        protected void setSlot(int n) {
            this.slot = n;
            if (this.slot == 1) {
                this.setLocation(new Point(411, 97));
                return;
            }
            this.setLocation(new Point(525, 97));
        }
    }
}

